﻿/*==============================================================================================
   HTML Parsing Blocks. The following vars contain HTML code to be inserted in the Register
   Today HTML pages based on the business logic, e.g., whether the registration is for a company
   or individual, whether an old serial number is needed, whether State/Region/Province is 
   required, etc.

   (C) Copyright 2004 by Autodesk, Inc.  All rights reserved.
  ==============================================================================================*/

/////////////////////////////////////////////
// LOCALIZATION RESOURCES HERE:
/////////////////////////////////////////////

/////////////////////////////////////////////
// Product Language: 
//
// NOTE TO LOCALIZATION: The list below was inserted on 29 Jan 2001 and it was up to date at that point.
// You may use the codes detailed below if you are sure that these have not changed (they generally don't change), otherwise, 
// please check these before inserting the language code.
/////////////////////////////////////////////
//
//English - US and International:  (en-us)
//German:  (de)
//French:   (fr)
//Italian:   (it)
//Spanish:   (es)
//Czech:   (cs)             
//Hungarian:   (hu)
//Polish:   (pl)
//Russian:   (ru)
//Japanese:   (ja)
//Korean:   (ko)
//Traditional Chinese (Taiwan) :   (zh-tw)
//Simplified Chinese (PRC) :   (zh-cn)
//Brazilian Portuguese (pt-br)
//
/////////////////////////////////////////////

//////////////////////////////////////////////
///// Add as ECO17 Direct Addition to the Privacy Policy 
/////
var xmsgGatherInfoDuringInstall= "Veuillez noter que toutes les données partagées lors de l'activation du produit sont utilisées conformément à Autodesk ";
var xmsgOfflinePrivacyWarning= "Si vous n’êtes pas connecté à Internet, définissez le codage de votre navigateur Internet Explorer (R) sur Sélection automatique pour afficher la politique de confidentialité. Si vous avez accès à Internet, la politique de confidentialité est également disponible sur le site Web autodesk.com."
////////////////////////////////////////////////////

var xmsgProductLanguage=	"fr";

/////////////////////////////////////////////
// Disable field color
/////////////////////////////////////////////
var xmsgDisableColor=		"#7f7f7f";

var xmsgNavigationBGColor=	"#f4f4f4";
var xmsgNavigationDisableColor=	"#808080";

/////////////////////////////////////////////
// HTML FILE TITLE STRINGS
/////////////////////////////////////////////
var xmsgRTAuthConfirmed=				"Autorisation confirmée";
var xmsgRTActLicFound=                  "Licence activée trouvée";
var xmsgRTActLicFoundError=            "Erreur d'enregistrement-activation"; 
var xmsgRTAuthEntryError=				"Erreur de saisie d'activation";
var xmsgRTAuthError=					"Erreur d'activation";
var xmsgRTAuthNow=						"Autoriser maintenant";
var xmsgRTBeginReg=						"Commencer l'enregistrement";
var xmsgRTBuyInformation=				"Informations d'achat";
var xmsgRTConfirm=						"Confirmation utilisateur";
var xmsgRTConnect=						"Connexion";
var xmsgRTConnectFail=					"Erreur de connexion";
var xmsgRTContactAutodesk=				"Contacter Autodesk";
var xmsgRTCountryPage=					"Pays";
var xmsgRTEmail=						"E-mail";
var xmsgRTFaxUS=						"Télécopie utilisateur";
var xmsgRTMailUS=						"Courrier utilisateur";
var xmsgRTPurchaseOffline=				"Achat hors ligne";
var xmsgRTRegConfirmed=					"Enregistrement confirmé";
var xmsgRTExportConfirm=                "Confirmation de l'exportation de la licence";
var xmsgRTImportConfirm=                "Confirmation de l'importation de la licence"; 
var xmsgRTRegVol=						"Enregistrer le produit";
var xmsgRTSUNDataConfirm=				"Confirmation SUN Data";
var xmsgRTSUNServer=					"Serveur SUN";
var xmsgRTSUNSubmit=					"Confirmation/Soumission utilisateur SUN";
var xmsgRTUserInfo=						"Informations utilisateur";
var xmsgRTLicFileSaveError=				"Erreur d'enregistrement du fichier de licence Flexlm";
var xmsgRTProductInfo=                   "Informations sur le produit"; //add by joyce.min on 2007-8-14
var xmsgNSARTBegin=						"Obtenir une licence réseau";
var xmsgNSARTLocateLicense=				"Localiser le fichier de licence";
var xmsgNSARTEditServerAndSeat=			"Entrer ou modifier les informations sur le serveur";
var xmsgNSARTConfirmServerAndSeat=		"Confirmer les informations sur le serveur";
var xmsgNSARTEnterSN=					"Entrer le numéro de série";
var xmsgProcessingError=				"Erreur de traitement";
var xmsgTimeout=        				"Cette session a expiré";

/////////////////////////////////////////////
// Software Information RESOURCES HERE:
/////////////////////////////////////////////
var xmsgActivationFor=	"Activation pour:";
var xmsgPurchase=       "Acheter:";
var xmsgRegistrationFor=       "Enregistrement de:";
var xmsgProduct=	"Produit: ";
var xmsgsernum=		"Numéro de série: ";
var xmsgsernumWGID=	"Numéro de série ou ID de groupe: ";//modify by joyce.min on 2007-8-16
var xmsgprokeyWGID=  "Clé de produit: "; // add by  joyce.min on 2007-8-16
var xmsgOsernum=	"Numéro de série précédent: ";
//var xmsgOprokey=      "Previous product key: "; // add by joyce.min on 2007-8-17
var xmsgOldSerialNum=	"Numéro de série précédent:*";
var xmsgNewSernum1=	"Entrez votre numéro de série ou votre ID de groupe:"; //???
//var xmsgNewProkey1=
var xmsgRequestCode=	"Code de requête: ";
var xmsgRegAuthCode=	"Code d'activation: ";
var xmsgApplicationKey=	"Clé de l'application: ";
var xmsgRTHostID=				"ID hôte:";
var xmsgRTFlexlmLicenseFile=	"Fichier de licence:";

/////////////////////////////////////////////
// Primary Rolodex RESOURCES HERE:
/////////////////////////////////////////////
var xmsgSalutation=	"Salutation:";
var xmsgNone=		"(aucun)";
var xmsgNotEntered=	"(non saisi)";
var xmsgFirstname=	"Prénom:";
//var xmsgFirstname= langCode+label.fname;
var xmsgFirstnameKanji=	"Prénom (Kanji):";
var xmsgFirstnameFurigana=	"Prénom (Zenkaku Kana):";
var xmsgLastname=	"Nom:";
var xmsgLastnameKanji=	"Nom (Kanji):";
var xmsgLastnameFurigana=	"Nom (Zenkaku Kana):";
var xmsgCompanyName=	"Société:*";
var xmsgCompanyName2=	"Société:";
var xmsgCompanyNameJP=	"Société (Kanji):";
var xmsgPhone=		"Téléphone:";
var xmsgArea=		"Zone:";
var xmsgNumber=		"Numéro:";
var xmsgExt=		"Poste:";
var xmsgFax=		"Télécopie:";
var xmsgFaxTo=		"Envoyer par télécopie à ";
var xmsgEmail=		"E-mail:";
var xmsgEmailTo=	"Envoyer par e-mail à ";
var xmsgAddress=	"Adresse postale:";
var xmsgAddress2=	"2ème adresse postale:";
var xmsgAddress3=	"3ème adresse postale:";
var xmsgJPAddress=	"Ville:";
var xmsgJPAddress2=	"Adresse postale:";
var xmsgJPAddress3=	"Immeuble (et numéro d'appartement):";
var xmsgCity=		"Ville:";
var xmsgSRP=		"Etat/Région/Province:";
var xmsgStText=		"Etat:";
var xmsgPrText=		"Province:";
var xmsgRegText=	"Région:";
var xmsgPrefectureText=	"Préfecture:";
var xmsgCountyText=	"Comté:";
var xmsgCantonText=	"Canton:";
var xmsgZipCode=	"Code postal:";
var xmsgPostCode=	"Code postal:";
var xmsgCountry=	"Pays ou région:";
var xmsgDealer=		"Revendeur Autodesk agréé:";
var xmsgMailTo=		"Envoyer par courrier à ";
var xmsgAnEmail=	"une adresse e-mail";
var xmsgAFax=		"un numéro de télécopie";
var xmsgAMailAddress=	"une adresse postale";
var xmsgPostalMail=		"Courrier postal";

///////////////////////////////////////////////
// Button RESOURCES HERE:
///////////////////////////////////////////////
var xmsgBack=			"<< Précédent";
var xmsgCancel=			"Fermer";
var xmsgNext=			"Suivant >>";
var xmsgPrint=			"Imprimer";
var xmsgPrintForm=		"Ouvrir le formulaire de demande d'activation";
var xmsgNo=				"Non";
var xmsgYes=			"Oui";
var xmsgBrowse=			"Parcourir";
var xmsgDone=			"Terminé";
var xmsgOK=				"OK";
var xmsgClose=			"Fermer";
var xmsgSubmit=			"Envoyer";
var xmsgFinish=			"Terminer";
var xmsgReset=			"Tout effacer";

///////////////////////////////////////////////
// Registration User Prompt RESOURCES HERE:
///////////////////////////////////////////////
var xmsgPleaseSelect=		"Veuillez sélectionner ";
var xmsgPleaseSelect2=		"Sélectionnez une option ci-dessous et cliquez sur Suivant.";
var xmsgSelectCountry=		"Pays ou région d'utilisation du produit:";
var xmsgSelectCountry2=		"Pays/Région:";
var xmsgInformation=		"Informations";
var xmsgCompanyInfo=		"Informations sur la société:";
var xmsgContactInfo=		"Informations personnelles:";
var xmsgResponseMethodInfo=	"Informations sur la méthode de réponse"; //modify as the Spec. recommond by joyce.min on 2007-8-17
var xmsgFormSubmitMethodInfo=	"Méthode d'envoi du formulaire:";
var xmsgConfirmInfo=		"Confirmation des informations";
var xmsgConfirmInfoTxt=		"Vérifiez les informations suivantes. Cliquez sur l'une des méthodes d'envoi du formulaire pour continuer et utiliser les informations affichées ou cliquez sur Précédent pour apporter des modifications.";
var xmsgConfirmCustIDInfoTxt=		"Confirmez les informations suivantes. Cliquez sur Suivant pour continuer ou sur Précédent pour apporter des modifications.";
var xmsgCountryHdr=			"Enregistrement du produit";
var xmsgCountryRegTo=		"Ce produit sera enregistré pour:";
var xmsgCountryComp=		"Une société";
var xmsgCountryIndiv=		"Un individu";
var xmsgCountryUpgrade=		"Il s'agit d'une mise à niveau";
var xmsgCountryUpgDetail=	"(Si vous êtes client de l'abonnement, cliquez sur Non.)";
var xmsgConnectHdr1=		"Connexion en cours";
var xmsgConnectHdr=		"Se connecter à Internet";
var xmsgConnectMsg=		"Connexion";
var xmsgConnectTxt=		"Aucune connexion à Internet n'a été détectée. Pour envoyer une requête en ligne, connectez-vous maintenant.";
var xmsgConnectTxtOLT=    "Aucune connexion Internet n'a été détectée. Pour transférer une licence, connectez-vous maintenant.";
var xmsgConnectTxt2=	"Une fois la connexion établie, cliquez sur Suivant.";
var xmsgConnectTxt3=	"Pour envoyer votre requête d'une autre manière, cliquez sur le lien suivant:";
var xmsgConnectWarming=	"L'envoi de ces informations peut prendre quelques minutes. Veuillez patienter.";
var xmsgTryAgain=		"Réessayer";
var xmsgReEnterOld=		"Veuillez ressaisir l'ancien numéro de série.";
var xmsgNewSernum3=		"Entrez le nouveau numéro de série et cliquez sur Suivant.";
var xmsgNewSernum4=		"Le numéro de série entré lors de l'installation de votre version d'évaluation (000-00000000) ne peut pas être enregistré. Si vous avez acheté ce logiciel, vous avez dû recevoir un nouveau numéro de série. Veuillez utiliser ce nouveau numéro pour activer le produit.";
var xmsgNewSernum5=		"Entrez votre numéro de série ou votre ID de groupe:"; //modify by joyce.min on 2007-8-16
var xmsgProductKey=      "Entrez votre clé de produit:"; //modify by joyce.min on 2007-8-16
var xmsgNewSernum6=		"Confirmez le nouveau numéro de série:";
var xmsgNewSernum8=		"Veuillez ressaisir le nouveau numéro de série.";
var xmsgUseOtherMethod=		"Utiliser une autre méthode d'enregistrement";
var xmsgContactAutodesk=	"Contacter Autodesk";
var xmsgContactAutodeskLink="Pour contacter Autodesk, cliquez sur le lien suivant:";
var xmsgContactOptions=		"Les options pour nous contacter sont indiquées ci-dessous.";

var xmsgPuchaseInfo1=		"Informations d'achat";
var xmsgPuchaseInfo2=		"Vous avez choisi d'acheter en ligne."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min
var xmsgPuchaseInfo3=		"Cliquez sur Suivant pour continuer ou sur Annuler pour abandonner."; //modify as the LF1_Spec_SCV commend on p99 by joyce.min

var xmsgRegTitle=		"Enregistrement - Activation";
var xmsgRegTitleBuy=		"Acheter des produits Autodesk en ligne";
var xmsgRegTitleNSA=		"Activation de licence réseau";
var xmsgRegInfo=		"Informations client";
var xmsgRegInfo2=		"Méthode d'enregistrement";
var xmsgRegInfo3=		"Sélectionnez une méthode d'enregistrement et cliquez sur Suivant.";
var xmsgRegmethod1=		"Connexion directe par Internet";
var xmsgRegmethod3=		"Je souhaite recevoir mon code d'activation par:";
var xmsgRegmethod5=		"Courrier";
var xmsgRegmethod6=		"Cliquez sur Imprimer et envoyez ce formulaire à:";
var xmsgRegmethod7=		"Télécopie";
var xmsgRegmethod8=		"Pour imprimer un formulaire que vous pouvez envoyer par télécopie à Autodesk au %1, choisissez d'abord la méthode de réception du code d'activation. Cliquez ensuite sur Imprimer. Vous pouvez ensuite envoyer le formulaire par télécopie.";
var xmsgRegmethod9=		"E-mail";
var xmsgRegmethod10NSA=		"Les informations relatives à votre enregistrement et à votre serveur de licence (indiquées ci-dessus) ont été automatiquement enregistrées dans un fichier.";
var xmsgRegmethod10=		"Les informations relatives à votre enregistrement ont été enregistrées dans le fichier suivant, qui sera utilisé pour terminer le processus d'envoi par e-mail (ne modifiez pas ce fichier):";
var xmsgRegmethod11NSA=		"Envoyez le fichier %1 contenant les informations relatives à l'enregistrement et au serveur de licence par e-mail à %2.";
var xmsgRegmethod11=		"Envoyez le fichier %1 contenant les informations relatives à l'enregistrement par e-mail à %2.";
var xmsgRegmethod12=		"Vous ne devez pas modifier ce fichier.<p>Nous vous conseillons d'imprimer une copie de cette page et de la conserver en lieu sûr. Vous aurez besoin de ces informations pour effectuer manuellement la procédure par e-mail.<p>Vous pouvez imprimer une copie de cette page pour référence. Cliquez sur Terminé pour fermer cette application.";
var xmsgRegmethod13=		"Pour attacher et envoyer automatiquement %1 à Autodesk, cliquez sur le lien ci-dessous.";
var xmsgRegmethod14=		"Envoyer ma demande par e-mail";
var xmsgRegmethod15=		"Remarque: l'adresse e-mail est automatisée. N'envoyez pas de communications électroniques à cette adresse.";
var xmsgRegmethod16=		"Pour effectuer l'enregistrement par télécopie ou courrier, cliquez sur l'un des liens suivants:";
var xmsgRegmethod17=		"Erreur lors de l'envoi du message e-mail";
var xmsgRegmethod18NSA=		"Une erreur s'est produite lorsque le système essayait d'envoyer automatiquement les informations relatives à l'enregistrement et au serveur de licence.";
var xmsgRegmethod18=		"Une erreur s'est produite lorsque le système essayait d'envoyer automatiquement les informations relatives à l'enregistrement.";
var xmsgRegmethod19=		"Pour envoyer le fichier par e-mail manuellement:";
var xmsgRegmethod20NSA=		"Envoyer le fichier %1 contenant les informations relatives à l'enregistrement et au serveur de licence par e-mail à %2.";
var xmsgRegmethod20=		"Envoyer le fichier %1 contenant les informations relatives à l'enregistrement par e-mail à %2.";
var xmsgRegmethod21=		"Vous ne devez pas modifier ce fichier.<p>Nous vous conseillons d'imprimer une copie de cette page et de la conserver en lieu sûr. Vous aurez besoin de ces informations pour effectuer manuellement la procédure par e-mail.<p>Vous pouvez imprimer une copie de cette page pour référence. Cliquez sur Terminé pour fermer cette application.";
var xmsgRegAuthInfo=		"Activation";
var xmsgRegAuthInfo1=		"Confirmation de l'enregistrement";
var xmsgRegExpConfirm=      "Confirmation de l'exportation de la licence";
var xmsgRegImpConfirm=      "Confirmation de l'importation de la licence";
var xmsgRegAuthInfo2=		"Obtenez un code d'activation";
var xmsgRegAuthInfo3=		"Entrez le code d'activation"; 
var xmsgRegAuthInfo4=		"Sélectionnez l'une des options suivantes:";
var xmsgRegAuthInfo4A=		"Entrez un code d'activation";
var xmsgRegAuthInfo4B=		"Entrez le code d'activation:"; 
var xmsgRegAuthInfo5=		"Sélectionnez votre pays ou votre région, entrez le code d'activation et cliquez sur Suivant.";
var xmsgRegAuthInfo6=		"Enregistrement - Confirmation de l'activation";	
var xmsgRegAuthInfo7=		"Merci d'avoir enregistré et activé votre produit.";
var xmsgRegAuthInfo8=		"Confirmation";		
var xmsgRegAuthInfo9=		"Merci d'avoir enregistré votre produit Autodesk. Ceci nous permettra d'être encore plus proche de vous dans l'avenir.";
var xmsgRegAuthInfo10=		"Une copie des informations d'enregistrement a été enregistrée à l'emplacement suivant:";		
var xmsgRegAuthInfo10B=		"Une copie des informations d'enregistrement a été enregistrée à l'emplacement suivant:";
var xmsgRegActLicInfo=      "Licence activée trouvée";
var xmsgRegActLicInfoError=      "Erreur d'enregistrement-activation";
var xmsgRegActiveInfo=        "Indiquez ou recherchez le chemin d'accès au fichier d'activation:";
var xmsgRegActLicInfo1=       "Une licence précédemment enregistrée et activée pour votre produit a été trouvée sur cet ordinateur. Merci."
var xmsgRegActLicInfo1Error= "Une licence précédemment enregistrée et activée pour votre produit a été trouvée sur cet ordinateur.\n Toutefois, une erreur inattendue (%1) est survenue. Fermez l'application, puis réessayez. Si ce problème persiste, contactez votre administrateur système ou votre revendeur Autodesk agréé.";

/////////////////////////////////////////////
// OLT Confirmation
/////////////////////////////////////////////
var xmsgExportSuccess=        "Exportation réussie"; //2008-01-16
var xmsgExportFail=           "Echec de la demande d'exportation" ; //2008-01-16
var xmsgRegErrRef=            "Référence de l'erreur:"; //2008-01-17
var xmsgImportSuccess=        "Importation réussie"; //2008-01-16
var xmsgImportFail=           "Echec de la demande d'importation"; //2008-01-16
var xmsgExpSucessInfo=        "Votre licence a été correctement exportée et est maintenant présente sur le serveur Autodesk."; //2008-01-16
var xmsgExpSuccessInfoHowtoImport=    "Comment importer votre licence";
var xmsgExpSucessInfo1=        "Avant de lancer le produit sur l'ordinateur de destination, importez la licence sur cet ordinateur via l'utilitaire de transfert de licence. Préparez votre ID utilisateur et votre mot de passe Autodesk.";  //2008-01-16
var xmsgImpSucessInfo=         "La licence a été correctement importée. Vous pouvez maintenant utiliser ce produit. "; //2008-01-16
var xmsgImpRemindInfo=         "Me rappeler de procéder à l'exportation."; //2008-01-16
var xmsgImpRemindInfo1=        "Si vous cochez cette case, une boîte de dialogue s'affiche chaque fois que vous quittez l'application et vous rappelle que vous devez exporter la licence.";//copy mockup 2008-01-16
var xmsgImpRemindInfo2=        "Cette option est utile si vous importez provisoirement la licence sur cet ordinateur et que vous devez la transférer à nouveau par la suite.";//copy mockup 2008-01-16
var xmsgImpRemindInfo3=        "L'option \"Ne plus afficher ce message\" est disponible dans le rappel.";//copy mockup 2008-01-16
var xmsgOltTryAgain=           "Cliquez sur le lien \"Réessayer\" pour réitérer la demande. ";
var xmsgImpFailMsg=            "Si le problème persiste, activez la licence au lieu de l'importer.";

var xmsgReqfilelocMsg=       "Le fichier de demande se trouve à l'emplacement suivant:";	//add by joyce.min on 2007-9-10 as Licensing Spec. recommend 	
var xmsgRegAuthInfo11=		"Merci d'avoir enregistré votre produit; il est désormais activé et votre fichier de licence est enregistré. Cliquez sur Imprimer si vous souhaitez conserver une version papier de cette page.";
var xmsgRegAuthInfo12=		"Collez le code d'activation.";
var xmsgRegAuthInfo13=		"Saisissez le code d'activation.";
var xmsgRegErrorActiveCode=    "<FONT color=red>Entrez un code d'activation pour continuer.</FONT>";
var xmsgRegErrorActiveCode1=    "<FONT color=red>Ce code d'activation est incorrect. Vérifiez qu'il ne contient pas d'erreur.</FONT>";
var xmsgRegErrorActiveFile=    "<FONT color=red>Entrez le chemin d'accès au fichier d'activation et le nom du fichier pour continuer.</FONT>";
var xmsgRegErrorSernum=      "<FONT color=red>Entrez un numéro de série pour continuer.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorSernum1=      "<FONT color=red>Le numéro de série est trop court.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorProkey=      "<FONT color=red>Entrez une clé de produit pour continuer.</FONT>"; //add by joyce.min on 2007-8-29
var xmsgRegErrorProkey1=     "<FONT color=red>La clé de produit est trop courte.</FONT>"; //add by joyce.min on 2007-9-7
var xmsgRegErrorHdr=		"Erreur d'enregistrement-activation";
var xmsgRegErrorSystem=		"Un incident système temporaire a généré des erreurs pendant l'enregistrement de votre produit. Cliquez sur l'un des liens suivants."
var xmsgRegErrorPrevReg=	"Le numéro de série que vous avez entré est déjà enregistré.";
var xmsgRegErrorMaxAuth=	"Vous avez dépassé le nombre maximal d'activations possible pour ce produit.";
var xmsgRegErrorMaxAuth2=	"Vous avez dépassé le nombre maximal de licences possible pour ce produit.";
var xmsgRegErrorInvalidOld=	"Le numéro de série entré pour votre ancien produit est incorrect. Vérifiez que l'ancien numéro de série affiché ci-dessus est correct. Cliquez sur l'un des liens suivants.";
var xmsgRegErrorData=		"Problème au niveau des informations d'enregistrement fournies. Sélectionnez Réessayer pour les revoir et les corriger, utilisez une autre méthode d'enregistrement ou contactez Autodesk pour continuer.";
var xmsgRegErrorNetwork=	"Le produit que vous tentez d'enregistrer est un produit autorisé pour les réseaux. Il doit être installé dans ce type d'environnement. Vous devez désinstaller le logiciel et sélectionner \"Réseau\" pour ce type d'installation.<p>Reportez-vous à la section concernant l'installation en réseau de ce guide d'installation pour connaître les procédures d'installation et d'activation de la version réseau.";
var xmsgRegNoResponse=		"Un incident temporaire a généré des erreurs pendant l'enregistrement en ligne de votre produit. Cliquez sur l'un des liens suivants.";
var xmsgRegErrorAuthEntry=	"Problème lié au code d'activation entré. Cliquez sur l'un des liens suivants.";
var xmsgRegErrorAuthPermission = "Pour activer ce produit Autodesk, vous devez disposer des permissions administrateur ou demander à votre administrateur système de vous octroyer des permissions élevées. Contactez-le pour obtenir plus d'informations sur le rôle d'un administrateur et les permissions élevées.";							
var xmsgRegErrorAuth=		"Problème lié au code d'activation. Cliquez sur l'un des liens suivants.";
var xmsgRegErrorFlex=		"Problème lié à la licence. Cliquez sur l'un des liens suivants.";
var xmsgRegConnError=		"Erreur de connexion";
var xmsgRegConnErrorTxt=	"Problème de connexion Internet. Cliquez sur l'un des liens suivants.";
var xmsgRegPurchError3=		"Utilisez une autre méthode d'achat";
//modified as LFSpec_SCV commend by joyce.min
var xmsgRegPurchError5=		 "Merci d'avoir choisi d'acheter ce logiciel Autodesk.<p>La connexion nécessaire pour terminer ce processus n'est pas disponible actuellement, probablement à cause de vos paramètres système.<p>Cliquez sur l'un des liens ci-dessous pour ouvrir votre navigateur; vous pourrez peut-être vous connecter de cette manière.<p>";

var xmsgAuthResellerMsg1=	"Achat auprès de votre revendeur. Contactez votre revendeur pour terminer cet achat.";

var xmsgLicSaveErrInfo=		"Une erreur s'est produite lors de l'enregistrement de votre fichier de licence. Cliquez sur l'un des liens suivants.";

var xmsgOnlineStoreMsg1=	"Achat sur Internet, dans la boutique Autodesk en ligne. Si vous ne trouvez pas le produit que vous recherchez, contactez un revendeur autorisé.";
var xmsgOnlineStoreMsg2=    "Sur Internet";
var xmsgAuthResellerMsg2=	"Revendeur autorisé";
var xmsgLocateLicenseMsg1=	"Localisez le fichier de licence";
var xmsgLocateLicenseMsg2=	"Entrez le chemin du fichier de licence (ou utilisez le bouton Parcourir pour le rechercher), puis cliquez sur Suivant pour continuer.";
var xmsgLocateLicenseMsg3=	"Fichier de licence existant:";
var xmsgUserContactMsg=		"Vous devez saisir au moins une des informations suivantes:";
var xmsgFailureMsg=		    "Votre demande d'activation en ligne n'a pas pu être traitée.";

/////////////////////////////////////////////
// Default Ereg returned error messages
/////////////////////////////////////////////
var xmsgDefaultEregReturnedErrMsg=  "Votre requête d'activation en ligne a retourné une erreur (%1) qui ne lui permet pas d'être traitée avec nos systèmes automatisés.";
var xmsgRegErrorOnline=		"Cliquez sur le lien \"Utiliser une autre méthode\" ci-dessous pour remplir les formulaires nécessaires, puis envoyez votre demande à l'Autodesk Business Center le plus proche. Un chargé de clientèle vous répondra dans un délai de deux jours ouvrés.";
var xmsgAnotherFormSubmitMethod=    "Utiliser une autre méthode";

/////////////////////////////////////////////
// Timeout message
/////////////////////////////////////////////
var xmsgTimeoutMsg1=    "Votre demande d'activation en ligne a expiré."
var xmsgTimeoutMsg2=    "Cliquez sur le lien \"Réessayer\" pour envoyer à nouveau la demande.Si le problème persiste, cliquez sur le lien \"Utiliser une autre méthode\" pour envoyer votre demande par e-mail, télécopie ou un autre moyen.";

/////////////////////////////////////////////
// Single User Network RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegSunData1=		"Données d'enregistrement sauvegardées";
var xmsgRegSunData2=		"Les données d'enregistrement nécessaires à la répartition du client ont été sauvegardées dans ";
var xmsgRegSunData3=		"Le numéro de série précédent fourni pour l'enregistrement de cette mise à niveau n'est pas valide. Veuillez contacter votre administrateur.";
var xmsgRegSunData4=		"Ce logiciel doit être réinstallé avec un numéro de série précédent valide.";
var xmsgRegSunData5=		"Répartition autonome pour plusieurs postes de travail";
var xmsgRegSunData6=		"Pour terminer la répartition autonome pour plusieurs postes de travail, vous devez communiquer certaines informations d'enregistrement. Les pages suivantes seront:";
var xmsgRegSunData7=		"Collecte des informations nécessaires.";
var xmsgRegSunData8=		"Autoriser la saisie d'un numéro de série précédent s'il est demandé lors d'une mise à niveau.";
var xmsgRegSunData9=		"Stocker ces informations sur le serveur pour la répartition sur toutes les installations clientes.";
var xmsgRegSunData10=		"Ce logiciel sera enregistré sur la base des informations suivantes. Cliquez sur Suivant pour continuer.";

/////////////////////////////////////////////
// Voluntary RESOURCES HERE:
/////////////////////////////////////////////
var xmsgRegVol1=	"Enregistrement du produit";
var xmsgRegVol2=	"Sélectionnez une option, puis cliquez sur Suivant:";
var xmsgRegVol3=	"Enregistrer maintenant - sélectionnez cette option pour lancer l'enregistrement en ligne";
var xmsgRegVol4=	"Enregistrer ultérieurement - sélectionnez cette option pour exécuter votre logiciel maintenant";
var xmsgRegVol5=	"Ne plus afficher ce message.";
var xmsgRegVol6=	"(Pour l'enregistrer ultérieurement, sélectionnez l'option correspondante dans la boîte de dialogue accessible par Aide|A propos de)";

/////////////////////////////////////////////
// Japan RESOURCES HERE:
/////////////////////////////////////////////
var xmsgCustIDMainTitle=	"Identification client";
var xmsgKatakana=		    "Nom de la société (Zenkaku Kana):";
var xmsgDepartment=		    "Département:";
var xmsgDepartment2=		"Nom du département:";

/////////////////////////////////////////////
// Autodesk Contact RESOURCES HERE:
/////////////////////////////////////////////
var xmsgFormWebHdr=	"Sur Internet:";
var xmsgFormWebDataMsg1= "Vous pouvez également obtenir un code d'activation sur le site:<br>";
var xmsgFormEmailHdr=	"E-mail:";
var xmsgFormEmailData=	"";
var xmsgFormEmailDataBlock= "";
var xmsgFormEmailXMLData=	"";
var xmsgFormEmailXMLDataBlock= "";
var xmsgFormFaxHdr=		"Télécopie:";
var xmsgFormFaxHdrLocal=	"Bureau de télécopie local:";
var xmsgFormFaxHdrReg=	"Enregistrement par télécopie:";
var xmsgFormFaxData=	"";
var xmsgFormFaxDataRegister=	"";
var xmsgFormCallHdr=	"Téléphone:";
var xmsgFormCallData=	"";
var xmsgFormMailHdr=	"Courrier postal:";
var xmsgFormMailHdrLocal=	"Bureau de poste local:";
var xmsgFormMailHdrReg=	"Enregistrement par courrier:";
var xmsgFormMailData=	"";
var xmsgFormMailDataRegister=   "";
var xmsgFormPurchHdr=	"Achat de logiciel";
var xmsgFormInternetMsg=    "Pour demander un code d'activation avec votre navigateur Web, cliquez sur le lien."
var xmsgFormEmailMsg=       "Envoyer la correspondance et les demandes d'activation par e-mail à:"

/////////////////////////////////////////////
// Privacy Statement RESOURCES HERE:
/////////////////////////////////////////////

var JPprivacystatement = "Les informations saisies seront utilisées par Autodesk pour enregistrer et/ou émettre votre code d'activation. L'enregistrement confirme que vous autorisez Autodesk à fournir des informations vous concernant à nos partenaires commerciaux agréés à des fins de gestion des licences relatives aux produits et de vérification des autorisations. Veuillez contacter Autodesk à l'adresse <a href=mailto:information@autodesk.jp>information@autodesk.jp</a> si vous préférez qu'Autodesk ne partage pas ces informations avec ses partenaires commerciaux agréés à ces fins précises. Si vous souhaitez corriger ou mettre à jour des informations précédemment saisies, cliquez <a %1>ICI</a> pour contacter Autodesk ou contactez votre revendeur.";
			
var privacystatement = "Les informations saisies seront utilisées par Autodesk pour enregistrer et/ou émettre votre code d'activation, pour vous tenir informé de nos produits et services et pour vous offrir tous les avantages réservés aux utilisateurs Autodesk agréés. Autodesk ne vend en aucun cas ces informations, ni ne les transmet à des tiers ne faisant pas partie d'Autodesk ou de nos partenaires commerciaux agréés. Si vous souhaitez corriger ou mettre à jour des informations précédemment saisies, cliquez <a %1>ICI</a> pour contacter Autodesk ou contactez votre revendeur.";
				
			
/////////////////////////////////////////////
// Privacy Policy
/////////////////////////////////////////////
var xmsgPrivacyPolicy="Politique de confidentialité";

/////////////////////////////////////////////
// Copyright
/////////////////////////////////////////////
var xmsgCopyright="(c) Copyright 2009 Autodesk, Inc. Tous droits réservés."; //modify by joyce.min on 2007-8-14

/////////////////////////////////////////////
// Rebranding Message
/////////////////////////////////////////////
var xmsgRebranding="Dans la plupart des cas, pour que le nouveau numéro de série s'affiche, vous devez fermer le programme et le redémarrer avec les droits d'administrateur.";
var xmsgRebranding2="Reportez-vous à la documentation de votre système d'exploitation pour obtenir des informations sur le démarrage des programmes avec les droits d'administrateur.";
/////////////////////////////////////////////
//  Note to Localization :
//
//	"InsertRegInfo" appears in RTUserInfo.html.  The full sentence in English is
//
//	"Fields marked in <FONT color=red>red</FONT> and with an asterisk (<FONT 
//	color=red>*</FONT>) are required to process your registration. Complete the form 
//	and click Next."
//
/////////////////////////////////////////////
var xmsgRegInfoMsg1= "Les champs signalés par <FONT color=red>*</FONT> sont obligatoires.";
var xmsgRegInfoMsg2= "Les informations saisies sur cette page sont stockées avec votre licence. Elles sont utilisées pour réactiver et mettre à jour les produits. Veillez à saisir correctement vos informations afin de ne pas retarder l'utilisation de votre produit.";

var xmsgLicLocationText1 = "Enregistrer le fichier de licence pour <b>%1</b> sous:";

// Set Registration Info Header
var InsertRegInfo =     "<p><b>"+xmsgRegInfo+"</b></p>" +
			  "<p>" + xmsgRegInfoMsg1 + "</p>";


//=======================================================================
// Application Usage Information
//=======================================================================
var xmsgAppUsage=	"Questions:";

var xmsgAppUsageQ1=	"Pour nous aider à mieux comprendre vos besoins, veuillez répondre à quelques questions.";
var xmsgAppUsageQ2=	"Qu'est-ce qui décrit le mieux votre activité principale?";

var xmsgAppUsageOption51=	"Conception - Aérospatiale et automobile ";
var xmsgAppUsageOption52=	"Architecture ";
var xmsgAppUsageOption53=	"Conception, construction et gestion en architecture ";
var xmsgAppUsageOption54=	"Construction: Bâtiments commerciaux ";
var xmsgAppUsageOption55=	"Construction: Résidentiel ";
var xmsgAppUsageOption56=	"Fabrication d'équipement pour la construction ";
var xmsgAppUsageOption57=	"Génie civil / Aménagement du territoire ";
var xmsgAppUsageOption58=	"Conception d'équipements: Informatique / Secteur médical / Bureaux ";
var xmsgAppUsageOption67=	"Conception de produits de consommation ";
var xmsgAppUsageOption59=	"Propriétaire de bâtiments d'entreprise ";
var xmsgAppUsageOption92=	"Défense ";
var xmsgAppUsageOption93=	"Conception de commandes électriques ";
var xmsgAppUsageOption94=	"Ingénierie de systèmes électriques ";
var xmsgAppUsageOption72=	"Ingénierie de l'environnement ";
var xmsgAppUsageOption95=	"Fabrication de produits métalliques ";
var xmsgAppUsageOption96=	"Architecture d'intérieur ";
var xmsgAppUsageOption97=	"Conception de machines ";
var xmsgAppUsageOption98=	"Fabrication: Approvisionnement / Vente / Marketing ";
var xmsgAppUsageOption40=	"Conception cartographique et de systèmes géographiques ";
var xmsgAppUsageOption41=	"Ingénierie de systèmes mécaniques (chauffage, ventilation, climatisation et tuyauterie) ";
var xmsgAppUsageOption42=	"Ingénierie de systèmes de plomberie et/ou de protection contre les incendies ";
var xmsgAppUsageOption43=	"Conception de centrales électriques et de traitement ";
var xmsgAppUsageOption44=	"Immobilier ";
var xmsgAppUsageOption45=	"Bâtiment, BTP ";
var xmsgAppUsageOption87=	"Télécommunications ";
var xmsgAppUsageOption46=	"Outils et modèles / Atelier d'usinage ";
var xmsgAppUsageOption47=	"Conception d'infrastructure de transport ";
var xmsgAppUsageOption48=	"Eau, gaz, électricité ";
var xmsgAppUsageOption49=	"Equipements sanitaires et canalisations d'égout ";
var xmsgAppUsageOption99=	"Autre ";

var xmsgWrongCountryCodeMsg=	"Erreur: aucun code de pays connu saisi!";

/////////////////////////////////////////////
// Version RESOURCES HERE:
/////////////////////////////////////////////
var xmsgVersion = "Version:"

/////////////////////////////////////////////
// Access RTFax or RTMail through RTEmail
/////////////////////////////////////////////
var xmsgAccessFaxMsg=		"Je vais envoyer ma demande par télécopie ou téléphone"; //modify by joyce.min on 2007-10-18 as Licensing_Framework Spec_Frozen.doc recommend 
var xmsgAccessMailMsg=		"Enregistrement par courrier.";
var xmsgAccessHereMsg=		"ici.";

/////////////////////////////////////////////
// Receive code by
/////////////////////////////////////////////
var xmsgReceiveCodeMsg=     "Je souhaite recevoir le code par:";
var xmsgReceiveCodeMsg1=     "Je recevrai mon fichier d'activation par e-mail."; //add by joyce.min on 2007-8-20
/////////////////////////////////////////////
// Messages for Ease of reauth or multi-seat client registration
/////////////////////////////////////////////
var xmsgNoDialogHdrMsg=		"Veuillez patienter pendant la vérification de <br>votre licence";
/////////////////////////////////////////////
//Resource for RTProductInfo
/////////////////////////////////////////////
var xmsgRTProductInfoTitle=      "Informations sur le produit"; //add by joyce.min on 2007-8-14
var xmsgRTProductInfoMsg1=        "Tous les champs sont obligatoires."; //add by joyce.min on 2007-8-14
/////////////////////////////////////////////
//Error for RTProductInfo
/////////////////////////////////////////////
//var xmsgsernumError=        "Enter a serial number to proceed."; //add by joyce.min on 2007-8-17
//var xmsgprokeyError=        "Enter a product key to proceed." ; //add by joyce.min on 2007-8-17
/////////////////////////////////////////////
// Resource for NSA_RTBegin.html
/////////////////////////////////////////////
var xmsgNSARTBeginTitle=	"Obtenir une licence réseau";
var xmsgNSARTBeginMsg1=		"Demander un fichier d'activation de licence réseau par:";
var xmsgNSARTBeginMsg2=		"Connexion directe (par Internet)";
var xmsgNSARTBeginMsg3=		"Envoyer la demande par e-mail, télécopie ou téléphone";
var xmsgNSARTBeginNoInternet=	"";

/////////////////////////////////////////////
// Edit server and seat information
/////////////////////////////////////////////
var xmsgEditServerHdrMsg1=	"Informations sur le serveur";
var xmsgEditServerHdrMsg2=	"Modèle de serveur de licence*";
var xmsgEditServerMsg1=		"Entrez ou modifiez les informations sur le serveur de licence.<br>Cliquez sur le bouton Rechercher pour remplir le champ ID hôte du serveur.<p>";
var xmsgEditServerMsg2=		"Commencez par les données d'hôte de serveur provenant d'un ou plusieurs fichiers de licence existants.";
var xmsgEditServerRemove=	"Supprimer";
var xmsgEditServerHostName=	"Nom hôte du serveur*";
var xmsgEditServerHostID=	"ID hôte*";
var xmsgEditServerSeat=		"Postes de travail*";
var xmsgEditServerSingle=	"Serveur unique";
var xmsgEditServerDistributed=	"Serveur distribué";
var xmsgEditServerRedundant=	"Serveur redondant";
var xmsgEditServerDots=		"...";
var xmsgEditServerLookup=	"Rechercher";
var xmsgEditServerAddServer=	"Ajouter";
var xmsgEditServerRemoveServer=	"Supprimer";
var xmsgEditServerTotal=	"Total:";
var xmsgEditServerExceedMaxServer=	"Remarque: vous pouvez obtenir la licence de 20 serveurs distribués au maximum en une seule fois. Si vous devez obtenir la licence d'un nombre supérieur de serveurs, contactez Autodesk.";
var xmsgEditServerSeatError=	"Les postes de travail ne doivent contenir que des valeurs numériques.";

var xmsgConfirmServerMsg=	"Passez en revue les informations suivantes. Cliquez sur Suivant pour continuer ou sur Précédent pour apporter des modifications.";
var xmsgConfirmServerMsg2=	"Lorsque vous cliquez sur Suivant, les informations sont envoyées à Autodesk via Internet.";
var xmsgConfirmServerHdr2=	"Modèle de serveur de licence:";
var xmsgConfirmServerHostName=	"Nom hôte du serveur";
var xmsgConfirmServerHostID=	"ID hôte";
var xmsgConfirmServerSeat=		"Postes de travail";
var xmsgConfirmServerTotal=		"Total des postes de travail:";

var xmsgLicErrorHdr=			"Erreur de licence"; 
var xmsgLicErrorInvalidSN=		"Le numéro de série que vous avez entré est incorrect. Vérifiez que le numéro de série affiché ci-dessus est correct. Cliquez sur l'un des liens suivants.";
var xmsgLicReEnterSN=			"Veuillez ressaisir le numéro de série et réessayer.";

var xmsgLic113Msg2=				"Le nombre total de postes de travail alloué à vos serveurs distribués dépasse ce nombre.";
var xmsgLic113ModifySeats=		"Modifier la répartition des postes de travail.";

var xmsgSaveLicenseHdr=			"Licence(s) reçue(s)";
var xmsgSaveLicenseMsg1=		"Vos fichiers de licence ont été envoyés par Autodesk. Vous devez maintenant les enregistrer dans des fichiers de licence.<p> <b>Enregistrer les licences dans des fichiers de licence</b><p><LI>L'<b>emplacement recommandé</b> pour vos fichiers de licence est le répertoire \"License\" dans lequel vous avez installé Autodesk Network License Manager sur votre serveur.&nbsp;&nbsp;";
var xmsgSaveLicenseMsg6=		"<LI>Si vous avez un <b>fichier de licence existant</b>, <b>insérez-y</b> la nouvelle licence.<br>Lorsque vous cliquez sur Suivant, le système insère automatiquement vos informations de licence à l'emplacement approprié de votre fichier existant.</LI>";
var xmsgSaveLicenseMsg2=		"Si le fichier spécifié ci-dessus est un fichier de licence existant :";
var xmsgSaveLicenseMsg3=		"Insérez-y les nouvelles informations de licence.";
var xmsgSaveLicenseMsg4=		"Remplacez le fichier de licence existant.";
var xmsgSaveLicenseMsg5=		"Veuillez corriger les erreurs suivantes:";

var xmsgSaveErrorFileNameTooLong=  "ERREUR: Le nom de fichier que vous avez entré est trop long.<br>" +
								"Modifiez-le, puis continuez.";
var xmsgSaveErrorNoPermission=	"ERREUR : vous n'avez pas la permission d'enregistrer le fichier dans l'emplacement spécifié.<br>Vous pouvez enregistrer le fichier dans un emplacement temporaire, obtenir la permission appropriée et déplacer le fichier ultérieurement.";
var xmsgSaveErrorNoDiskSpace=	"ERREUR : vous n'avez pas assez d'espace disque pour enregistrer le fichier à l'emplacement spécifié.<BR>Vous pouvez enregistrer le fichier dans un emplacement temporaire et déplacer le fichier lorsque vous aurez libéré de l'espace disque.";
var xmsgSaveErrorInvalidFile=	"ERREUR : La nouvelle licence n'a pas pu être ajoutée au fichier sans perdre des données. Le fichier spécifié concerne peut-être un autre poste de travail ou un autre modèle de serveur.<BR>Vous pouvez enregistrer le nouveau fichier de licence avec un nom et un emplacement différent et l'ajouter au fichier ultérieurement.";															
var xmsgSaveErrorPathNotExit=	"ERREUR : le chemin spécifié n'existe pas.<BR>Cliquez sur le bouton Parcourir pour trouver le chemin ou en créer un nouveau.";
var xmsgSaveErrorPathBlank=		"ERREUR : vous devez spécifier un chemin et un nom de fichier de licence valides. Spécifiez le chemin et le nom de fichier dans le champ ci-dessous ou cliquez sur Parcourir pour les rechercher.";

var xmsgLicAuthConfirmHdr1=		"Activation de la licence réussie.";
var xmsgLicAuthConfirmHdr2=		"Informations sur l'hôte du serveur de licence";
var xmsgLicAuthConfirmMsg1=		"Merci d'avoir enregistré votre produit. Vous pouvez imprimer ces informations.";
var xmsgLicAuthConfirmDate=		"Date:";

var xmsgLicPathMsg1=			"Les fichiers de licence suivants ont été enregistrés:";
var xmsgLicPathMsg2=			"Vos fichiers de licence ont été enregistrés dans:";

var xmsgOtherMethodMsg1NSA=		"Utilisez une autre méthode pour obtenir une licence autorisée.";
var xmsgOtherMethodMsg1=		"Utilisez une autre méthode.";

var xmsgContactAutodeskMsg1=	"Contactez Autodesk par l'une des méthodes suivantes.";
								
/////////////////////////////////////////////
// Email Options
/////////////////////////////////////////////
var xmsgEmailOptionNSATitle=	"Obtenir un fichier de licence par e-mail";
var xmsgEmailOptionTitle=		"Enregistrer votre produit par e-mail";
var xmsgEmailOptionNSAMsg=		"Les informations relatives à l'enregistrement de votre produit et à votre serveur de licence ont été enregistrées automatiquement dans un fichier. Le fichier doit être envoyé par e-mail au centre de traitement des enregistrements automatiques d'Autodesk.<p>Dès que l'envoi du fichier à Autodesk a réussi, vous recevez une réponse automatique, un fichier de licence autorisé et des instructions sur l'exécution de la procédure.";
var xmsgEmailOptionMsg=			"Les informations relatives à l'enregistrement de votre produit ont été enregistrées automatiquement dans un fichier. Le fichier doit être envoyé par e-mail au centre de traitement des enregistrements automatiques d'Autodesk.<p>Dès que l'envoi du fichier à Autodesk a réussi, vous recevez une réponse automatique et des instructions sur l'exécution de la procédure.";
var xmsgEmailOptionMsg2=		"Si le système de messagerie par défaut que vous utilisez peut envoyer le message e-mail par Internet, cliquez sur Envoyer le fichier maintenant, puis cliquez sur Suivant. Le fichier sera envoyé automatiquement.<p>Si vous n'avez pas accès à la messagerie, cliquez sur Envoyer le fichier ultérieurement. Vous recevrez des instructions pour envoyer le fichier manuellement.";
var xmsgEmailOptionInfo1=		"Envoyer le fichier maintenant.";
var xmsgEmailOptionInfo2=		"Envoyer le fichier ultérieurement, manuellement.";
var xmsgEmailOptionInfo3=		"Envoyer une copie du message e-mail à l'adresse électronique que j'ai indiquée.";

/////////////////////////////////////////////
// Email Error
/////////////////////////////////////////////
var xmsgEmailErrorHdr=			"Impossible de créer l'e-mail";
var xmsgEmailErrorMsg1=			"Pour terminer l'enregistrement par e-mail, attachez le fichier suivant à un message:";
var xmsgEmailErrorMsg2=			"Envoyez l'e-mail à %1.";
var xmsgEmailErrorMsg3=			"Vous trouverez ce fichier à l'emplacement suivant:";

/////////////////////////////////////////////
// Local HERE customer information URLs
/////////////////////////////////////////////
var xmsgLocalHERETitle=			"Modifier les informations client";
var xmsgLocalHEREInfo=			"Pour modifier les informations client, contactez votre revendeur Autodesk agréé ou naviguez vers le lien ci-dessous correspondant à votre pays ou région.";
var xmsgLocalHEREUS=			"Amérique du Nord et Amérique du Sud";
var xmsgLocalHEREEMEA=			"Europe, Moyen-Orient, Afrique";
var xmsgLocalHEREAPAC=			"Région Asie/Pacifique";

/////////////////////////////////////////////
// Help
/////////////////////////////////////////////
var xmsgHelpTitle=				"Aide";
var xmsgHelpUpgradeMsg=			"Si vous procédez à l'enregistrement ou à l'activation d'une mise à niveau à partir d'une version antérieure, vous devez cocher cette case. Vous serez invité à saisir le numéro de série de la version utilisée pour effectuer la mise à niveau.";
var xmsgHelpUpgradeRequiredTitle=	"Entrez le numéro de série du produit précédent (nécessaire dans le cas de mises à niveau)";
var xmsgHelpUpgradeRequiredMsg=	"Il s'agit du numéro de série relatif à la version logicielle antérieure. Vous pourrez le trouver dans la boîte de dialogue A propos de (via le menu d'aide) du logiciel ou sur l'emballage du produit précédent.";

//	Fax or email error message
var xmsgNotEnterErrorMsg=		"Vous n'avez pas saisi %1. Entrez cette information si vous souhaitez recevoir votre code d'activation de cette façon.";								

//  Help for serial number
var xmsgHelpSerialNumberTitle=  "Numéro de série/ID de groupe"; ////modify by joyce.min on 2007-8-16
var xmsgHelpSerialNumberMsg=    "Votre numéro de série se trouve sur l'emballage du produit ou dans l'e-mail Informations sur les mises à jour et les licences Autodesk."; // ECO19

//  Help for ProductInfo serial number & Product Key //modify by joyce.min on 2007-8-16
var xmsgHelpProductKeyTitle=   "Clé de produit";
var xmsgHelpProductKeyMsg=    "Votre clé de produit figure à côté du numéro de série sur l'emballage du produit ou dans l'e-mail Informations sur les mises à jour et les licences Autodesk."; // ECO19

/////////////////////////////////////////////
// The following strings are added back for backward competibility reason
/////////////////////////////////////////////
var xmsgRT0015TempSysErr=				"Erreur de connexion (0.15)";
var xmsgRT010203071213CannotCompErrA=	"Erreur d'enregistrement (1.2.3.7.12.13)";
var xmsgRT09AlreadyReg=					"Déjà enregistré (9)";
var xmsgRT10ExceededAuths=				"Nombre d'autorisations dépassé (10)";
var xmsgRT12StolenSN=					"Numéro de série volé (12)";
var xmsgRT18OldSNInvalid=				"Numéro de série précédent incorrect (18)";
var xmsgRT20DataError=					"Erreur de données (20)";
var xmsgRT21CustIDTelErr=				"Erreur liée à l'ID client/N° de téléphone (21)";
var xmsgRT22NetworkInstallation=		"Erreur d'installation réseau (22)";
var xmsgRT900SystemNotResponding=		"Le système ne répond pas (900)";
var xmsgRTCustID=						"ID client";
var xmsgRTCustIDConfirm=				"Confirmation de l'identification";
var xmsgRTNewSerialNumber=				"Informations du nouveau numéro de série";
var xmsgRTNoNewSN=						"Erreur liée à la transaction d'achat";
var xmsgRTPurchAuthFailed=				"Erreur d'activation";
var xmsgRTPurchConfirmOther=			"Confirmation de l'achat";
var xmsgRTPurchConfirmPerm=				"Confirmation de l'achat - Enregistré et activé";
var xmsgRTPurchConfirmReg=				"Confirmation de l'achat - Enregistré mais pas activé";
var xmsgRTPurchConfirmRegVol=			"Confirmation de l'achat - Enregistré";
var xmsgRTPurchConfirmRent=				"Confirmation de l'achat - Enregistré et location active";
var xmsgRTPurchConfirmUnReg=			"Confirmation de l'achat - Pas enregistré ou activé";
var xmsgRTPurchConnectionFailed=		"Echec de la connexion de l'achat";
var xmsgRTPurchaseError=				"Erreur de l'achat";
var xmsgRTSNMismatch=					"Erreur de transaction de l'achat - Le numéro de série ne correspond pas";
var xmsgRTSUNOldSNInvalid=				"Numéro de série précédent incorrect - SUN";

var szRTEmail =         "RTEmail.html";

var xmsgExit=			"Quitter";

var xmsgCustIDMainTitle=	"Identification du client";
var xmsgCustIDTitle1=		"ID client:";
var xmsgCustIDText2=		"Entrez votre ID client et votre numéro de téléphone ci-dessous. Si vous ne possédez pas d'ID client, ne renseignez pas ces deux champs.<p> ";
var xmsgCustIDText3=		"Remarque : si vous réactivez votre produit, vous devez entrer un ID client.";
var xmsgCustIDText3NSA=		"Remarque : si vous réautorisez votre produit, vous devez entrer un ID client.";
var xmsgCustIDTitle2=		"Numéro de téléphone:";
var xmsgCustIDTelEx4=		"(exemple: 03-111-1234)";
var xmsgRegCustIDTel=		"L'ID client et le numéro de téléphone que vous avez entrés ne correspondent pas aux données de nos dossiers. Cliquez sur un des liens suivants.";

/////////////////////////////////////////////
//  Note to Localization :
//
//	"xmsgRT113SeatMsg1" appears in NSA_RT113TooManySeats.html.  The full sentence in English is
//
//	"Our records indicate that you have [Max allowed seats] valid [product name] seats available." 
/////////////////////////////////////////////
var xmsgRT113SeatMsg1=	"Nos dossiers indiquent que vous possédez %1 licences correctes %2 disponibles.<br>";

/////////////////////////////////////////////
// Error 12
/////////////////////////////////////////////
var xmsgErr12Hdr=				"Le numéro de série que vous avez entré est incorrect";
var xmsgErr12APAC=				"<p>Ce numéro de série est incorrect et ne peut pas être activé. Veuillez nous contacter à <a href=mailto:apacpl@listproc.autodesk.com target=\"_blank\">apacpl@listproc.autodesk.com</a></p>";
var xmsgErr12EMEA=				"<p>Madame, Monsieur</p><p>Merci d'avoir essayé d'enregistrer votre produit logiciel Autodesk&#0174; ou Discreet&#0153; avec Autodesk.</p><p>Malheureusement, nos dossiers indiquent que le numéro de série du produit logiciel Autodesk&#0174; ou Discreet&#0153; que vous avez tenté d'enregistrer est incorrect ou qu'il est connu comme étant une copie pirate de ce produit. Par conséquent, le produit logiciel Autodesk&#0174; ou Discreet&#0153; que vous utilisez n'est pas autorisé.</p><p>Les licences d'utilisation des produits logiciels Autodesk&#0174; peuvent être achetées auprès des revendeurs agréés d'Autodesk – veuillez consulter l'adresse <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> pour obtenir la liste des revendeurs agréés d'Autodesk ou pour connaître le bureau local Autodesk le plus proche. L'utilisation d'un logiciel légal est la seule méthode qui vous permet de façon certaine de bénéficier du maximum d'avantages liés à l'utilisation de votre logiciel ET d'éviter d'éventuelles poursuites civiles ou pénales si votre utilisation ou reproduction illégale des logiciels est découverte.</p><p>Les licences d'utilisation des produits logiciels Discreet&#0153; peuvent être achetées auprès des revendeurs agréés Discreet – veuillez consulter l'adresse <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> pour obtenir la liste des revendeurs agréés Discreet ou pour connaître le bureau local Discreet le plus proche. L'utilisation d'un logiciel légal est la seule méthode qui vous permet de bénéficier du maximum d'avantages liés à l'utilisation de votre logiciel ET d'éviter d'éventuelles poursuites civiles ou pénales si votre utilisation ou reproduction illégale des logiciels est découverte.</p><p>Nous vous prions par conséquent d'arrêter immédiatement d'utiliser le produit logiciel non autorisé que vous avez tenté d'enregistrer auprès de nos services, de supprimer les copies stockées sur votre matériel informatique et de détruire les supports contenant ce produit logiciel. Bien que nous pensions que vous adhérerez volontairement à notre requête, Autodesk se réserve le droit, à ce sujet, de transmettre vos coordonnées à l'alliance BSA (Business Software Alliance).</p><p>Si vous avez des questions ou pensez que vous avez reçu ce message par erreur, veuillez nous contacter à : <a href=mailto:emea.register@activation.autodesk.com target=\"_blank\">Authcodes.neu@activation.autodesk.com</a></p><p>Si vous souhaitez donner des informations sur l'utilisation ou la vente de logiciels illégaux, veuillez contacter votre bureau Autodesk local ou l'alliance BSA en consultant le site <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Merci</p>Merci</p>";
var xmsgErr12US=				"<p>Madame, Monsieur</p><p>Merci d'avoir essayé d'enregistrer votre produit logiciel avec Autodesk ou Discreet.</p><p>Malheureusement, nos dossiers indiquent que le numéro de série du produit logiciel Autodesk&#0174; ou Discreet&#0153; que vous avez tenté d'enregistrer est incorrect ou qu'il est connu comme étant une copie pirate de ce produit. Par conséquent, le produit logiciel Autodesk&#0174; ou Discreet&#0153; que vous utilisez n'est pas autorisé.</p><p>Pour les utilisateurs Autodesk, les licences d'utilisation des produits logiciels Autodesk&#0174; peuvent être achetées auprès des revendeurs agréés d'Autodesk – veuillez consulter l'adresse <a href=\"http://www.autodesk.com\" target=\"_blank\">www.autodesk.com</a> pour obtenir la liste des revendeurs agréés d'Autodesk ou pour connaître le bureau local Autodesk le plus proche. L'utilisation d'un logiciel légal est la seule méthode qui vous permet de façon certaine de bénéficier du maximum d'avantages liés à l'utilisation de votre logiciel ET d'éviter d'éventuelles poursuites civiles ou pénales si votre utilisation ou reproduction illégale des logiciels est découverte.</p><p>Pour les utilisateurs Discreet, les licences d'utilisation des produits logiciels Discreet&#0153; peuvent être achetées auprès des revendeurs agréés Discreet – veuillez consulter l'adresse <a href=\"http://www.discreet.com\" target=\"_blank\">www.discreet.com</a> pour obtenir la liste des revendeurs agréés Discreet ou pour connaître le bureau local Discreet le plus proche. L'utilisation d'un logiciel légal est la seule méthode qui vous permet de bénéficier du maximum d'avantages liés à l'utilisation de votre logiciel ET d'éviter d'éventuelles poursuites civiles ou pénales si votre utilisation ou reproduction illégale des logiciels est découverte.</p><p>Vous devez arrêter immédiatement d'utiliser le produit logiciel non autorisé que vous avez tenté d'enregistrer auprès de nos services, supprimer les copies stockées sur votre matériel informatique et détruire les supports contenant ce produit logiciel. Bien que nous pensions que vous adhérerez volontairement à notre requête, Autodesk se réserve le droit, à ce sujet, de transmettre vos coordonnées à l'alliance BSA (Business Software Alliance).</p><p>Si vous avez des questions ou pensez que vous avez reçu ce message par erreur, veuillez nous contacter à : <a href=mailto:Authcodes.neu@autodesk.com target=\"_blank\">Authcodes.neu@autodesk.com</a></p><p>Si vous souhaitez donner des informations sur l'utilisation ou la vente de logiciels illégaux, veuillez contacter votre bureau Autodesk local ou l'alliance BSA en consultant le site <a href=\"http://www.BSA.org\" target=\"_blank\">www.BSA.org</a></p><p>Merci</p>";






// SIG // Begin signature block
// SIG // MIIVVAYJKoZIhvcNAQcCoIIVRTCCFUECAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFOcyGQveI5yK
// SIG // o+6Ya4HgIN8x7itkoIIRFjCCA3owggJioAMCAQICEDgl
// SIG // 1/r4Ya+e9JDnJrXWWtUwDQYJKoZIhvcNAQEFBQAwUzEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMSswKQYDVQQDEyJWZXJpU2lnbiBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBMB4XDTA3MDYxNTAwMDAwMFoX
// SIG // DTEyMDYxNDIzNTk1OVowXDELMAkGA1UEBhMCVVMxFzAV
// SIG // BgNVBAoTDlZlcmlTaWduLCBJbmMuMTQwMgYDVQQDEytW
// SIG // ZXJpU2lnbiBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIFNp
// SIG // Z25lciAtIEcyMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
// SIG // iQKBgQDEtfJSFbyIhmApFkpbL0uRa4eR8zVUWDXq0TZe
// SIG // Yk1SUTRxwntmHYnI3SrEagr2N9mYdJH2kq6wtXaW8alK
// SIG // Y0VHLmsLkk5LK4zuWEqL1AfkGiz4gqpY2c1C8y3Add6N
// SIG // q8eOHZpsTAiVHt7b72fhcsJJwp5gPOHivhajY3hpFHut
// SIG // LQIDAQABo4HEMIHBMDQGCCsGAQUFBwEBBCgwJjAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24uY29t
// SIG // MAwGA1UdEwEB/wQCMAAwMwYDVR0fBCwwKjAooCagJIYi
// SIG // aHR0cDovL2NybC52ZXJpc2lnbi5jb20vdHNzLWNhLmNy
// SIG // bDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAOBgNVHQ8B
// SIG // Af8EBAMCBsAwHgYDVR0RBBcwFaQTMBExDzANBgNVBAMT
// SIG // BlRTQTEtMjANBgkqhkiG9w0BAQUFAAOCAQEAUMVLyCSA
// SIG // 3+QNJMLeGrGhAqGmgi0MgxWBNwqCDiywWhdhtdgF/ojb
// SIG // 8ZGRs1YaQKbrkr44ObB1NnQ6mE/kN7qZicqVQh2wuceg
// SIG // jVfg+tVkBEI1TgHRM6IXyE2qJ8fy4YZMAjhNg3jG/FPg
// SIG // 6+AGh92klp5eDJjipb6/goXDYOHfrSjYx6VLZNrHG1u9
// SIG // rDkI1TgioTOLL4qa67wHIT9EQQkHtWUcJLxI00SA66HP
// SIG // yQK0FM9UxxajgFz5eT5dcn2IF54sQ6LKU859PfYqOrhP
// SIG // lAClbQqDXfleU/QYs1cPcMP79a2VoA4X3sQWgGDJDytu
// SIG // hgTx6/R4J9EFxe40W165STLyMzCCA8QwggMtoAMCAQIC
// SIG // EEe/GZXfjVJGQ/fbbUgNMaQwDQYJKoZIhvcNAQEFBQAw
// SIG // gYsxCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJu
// SIG // IENhcGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYD
// SIG // VQQKEwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0
// SIG // aWZpY2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0
// SIG // YW1waW5nIENBMB4XDTAzMTIwNDAwMDAwMFoXDTEzMTIw
// SIG // MzIzNTk1OVowUzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMSswKQYDVQQDEyJWZXJpU2ln
// SIG // biBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqcqypMzN
// SIG // IK8KfYmsh3XwtE7x38EPv2dhvaNkHNq7+cozq4QwiVh+
// SIG // jNtr3TaeD7/R7Hjyd6Z+bzy/k68Numj0bJTKvVItq0g9
// SIG // 9bbVXV8bAp/6L2sepPejmqYayALhf0xS4w5g7EAcfrkN
// SIG // 3j/HtN+HvV96ajEuA5mBE6hHIM4xcw1XLc14NDOVEpkS
// SIG // ud5oL6rm48KKjCrDiyGHZr2DWFdvdb88qiaHXcoQFTyf
// SIG // hOpUwQpuxP7FSt25BxGXInzbPifRHnjsnzHJ8eYiGdvE
// SIG // s0dDmhpfoB6Q5F717nzxfatiAY/1TQve0CJWqJXNroh2
// SIG // ru66DfPkTdmg+2igrhQ7s4fBuwIDAQABo4HbMIHYMDQG
// SIG // CCsGAQUFBwEBBCgwJjAkBggrBgEFBQcwAYYYaHR0cDov
// SIG // L29jc3AudmVyaXNpZ24uY29tMBIGA1UdEwEB/wQIMAYB
// SIG // Af8CAQAwQQYDVR0fBDowODA2oDSgMoYwaHR0cDovL2Ny
// SIG // bC52ZXJpc2lnbi5jb20vVGhhd3RlVGltZXN0YW1waW5n
// SIG // Q0EuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA4GA1Ud
// SIG // DwEB/wQEAwIBBjAkBgNVHREEHTAbpBkwFzEVMBMGA1UE
// SIG // AxMMVFNBMjA0OC0xLTUzMA0GCSqGSIb3DQEBBQUAA4GB
// SIG // AEpr+epYwkQcMYl5mSuWv4KsAdYcTM2wilhu3wgpo17I
// SIG // ypMT5wRSDe9HJy8AOLDkyZNOmtQiYhX3PzchT3AxgPGL
// SIG // OIez6OiXAP7PVZZOJNKpJ056rrdhQfMqzufJ2V7duyuF
// SIG // PrWdtdnhV/++tMV+9c8MnvCX/ivTO1IbGzgn9z9KMIIE
// SIG // vzCCBCigAwIBAgIQQZGhWjl4389JZWY4HUx1wjANBgkq
// SIG // hkiG9w0BAQUFADBfMQswCQYDVQQGEwJVUzEXMBUGA1UE
// SIG // ChMOVmVyaVNpZ24sIEluYy4xNzA1BgNVBAsTLkNsYXNz
// SIG // IDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBB
// SIG // dXRob3JpdHkwHhcNMDQwNzE2MDAwMDAwWhcNMTQwNzE1
// SIG // MjM1OTU5WjCBtDELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZWZXJpU2ln
// SIG // biBUcnVzdCBOZXR3b3JrMTswOQYDVQQLEzJUZXJtcyBv
// SIG // ZiB1c2UgYXQgaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYSAoYykwNDEuMCwGA1UEAxMlVmVyaVNpZ24gQ2xh
// SIG // c3MgMyBDb2RlIFNpZ25pbmcgMjAwNCBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAL687rx+74Pr
// SIG // 4DdP+wMQOL4I0ox9nfqSfxkMwmvuQlKM3tMcSBMl6sFj
// SIG // evlRZe7Tqjv18JScK/vyZtQk2vf1n24ZOTa80KN2CB4i
// SIG // JyRsOJEn4oRJrhuKof0lgiwQMOhxqyjod0pR8ezN+PBU
// SIG // 1G/A420Kj9nYZI1jsi1OJ/aFDv5t4ymZ4oVHfC2Gf+hX
// SIG // j61nwjMykRMg/KkjFJptwoRLdmgE1XEsXSH6iA0m/R8t
// SIG // kSvnAVVN8m01KILf2WtcttbZqoH9X82DumOd0CL8qTtC
// SIG // abKOOrW8tJ4PXsTqLIKLKP1TCJbdtQEg0fmlGOfA7lFw
// SIG // N+G2BUhSSG846sPobHtEhLsCAwEAAaOCAaAwggGcMBIG
// SIG // A1UdEwEB/wQIMAYBAf8CAQAwRAYDVR0gBD0wOzA5Bgtg
// SIG // hkgBhvhFAQcXAzAqMCgGCCsGAQUFBwIBFhxodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhMDEGA1UdHwQqMCgw
// SIG // JqAkoCKGIGh0dHA6Ly9jcmwudmVyaXNpZ24uY29tL3Bj
// SIG // YTMuY3JsMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEF
// SIG // BQcDAzAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEB
// SIG // BAQDAgABMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFD
// SIG // bGFzczNDQTIwNDgtMS00MzAdBgNVHQ4EFgQUCPVR6Pv+
// SIG // PT1kNnxoz1t4qN+5xTcwgYAGA1UdIwR5MHehY6RhMF8x
// SIG // CzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwg
// SIG // SW5jLjE3MDUGA1UECxMuQ2xhc3MgMyBQdWJsaWMgUHJp
// SIG // bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eYIQcLrk
// SIG // HRDZKTS2OMp7A8y6vzANBgkqhkiG9w0BAQUFAAOBgQCu
// SIG // Ohe4SntV+mRV7ECk7UlBkJmcibyvLh3KeCP5HBkPf+to
// SIG // vDLZiDje3D/TibQ/sYKW8aRauu0uJtPefAFuAAoApAaS
// SIG // EUgJQPkcGHlnIyTgu9XhUK4b9Q7d4C6BzYCjbFJPkXVV
// SIG // iroi8tLqQXWIL2NVfR5UWpVZytk0gcBfXvZ6tTCCBQkw
// SIG // ggPxoAMCAQICEErej526uUojb1I0pA35Pn4wDQYJKoZI
// SIG // hvcNAQEFBQAwgbQxCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE7MDkGA1UECxMyVGVybXMg
// SIG // b2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZlcmlzaWduLmNv
// SIG // bS9ycGEgKGMpMDQxLjAsBgNVBAMTJVZlcmlTaWduIENs
// SIG // YXNzIDMgQ29kZSBTaWduaW5nIDIwMDQgQ0EwHhcNMDgw
// SIG // MzIwMDAwMDAwWhcNMDkwMzIwMjM1OTU5WjCBzDELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzAR
// SIG // BgNVBAcTClNhbiBSYWZhZWwxFzAVBgNVBAoUDkF1dG9k
// SIG // ZXNrLCBJbmMuMSEwHwYDVQQLFBhQU0VCLUxpY2Vuc2lu
// SIG // ZyAmIEluc3RhbGwxPjA8BgNVBAsTNURpZ2l0YWwgSUQg
// SIG // Q2xhc3MgMyAtIE1pY3Jvc29mdCBTb2Z0d2FyZSBWYWxp
// SIG // ZGF0aW9uIHYyMRcwFQYDVQQDFA5BdXRvZGVzaywgSW5j
// SIG // LjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAp+6n
// SIG // nTaWIaaik4EgXpsaskB3OTSOClzOXYCXAb72SwJCpwl9
// SIG // vER/uhH7cq2P7d6UNPue0OFVpr73qgMo0/TVXms6jug1
// SIG // n+nHo55JZcMOaDDprfsuuDznAmsiMoZoAdnMO1n3ZBbp
// SIG // gXcZ6xujdhb+wllM1s165yyYM+tTZlI53s8CAwEAAaOC
// SIG // AX8wggF7MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeA
// SIG // MEAGA1UdHwQ5MDcwNaAzoDGGL2h0dHA6Ly9DU0MzLTIw
// SIG // MDQtY3JsLnZlcmlzaWduLmNvbS9DU0MzLTIwMDQuY3Js
// SIG // MEQGA1UdIAQ9MDswOQYLYIZIAYb4RQEHFwMwKjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L3JwYTATBgNVHSUEDDAKBggrBgEFBQcDAzB1BggrBgEF
// SIG // BQcBAQRpMGcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3Nw
// SIG // LnZlcmlzaWduLmNvbTA/BggrBgEFBQcwAoYzaHR0cDov
// SIG // L0NTQzMtMjAwNC1haWEudmVyaXNpZ24uY29tL0NTQzMt
// SIG // MjAwNC1haWEuY2VyMB8GA1UdIwQYMBaAFAj1Uej7/j09
// SIG // ZDZ8aM9beKjfucU3MBEGCWCGSAGG+EIBAQQEAwIEEDAW
// SIG // BgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG9w0B
// SIG // AQUFAAOCAQEAoPt/JaNzwVvcuubHYt0M860+ntlMVoew
// SIG // XuvpZovRS8qzZTdLQDOGL4DL5GfVcC3t8YyomUYLJ7Rh
// SIG // BGhjuPyDtinUxw85rWZ+OHDkSvmPL0seDyJeUELj17qU
// SIG // JHCwJyeAErkw8vt7Tyi8XZjF2YP3PCGBYTX2s2qMTlXZ
// SIG // z6nqHnbN564AtxqBHcu4HXoKUT28fFhZEmYIANzmRaTi
// SIG // ZBYFFxaAf89H9xBSE+WqOiLP0W7FGJ6FTRyCIAkwFOfY
// SIG // Xi34nFfP62xKRrD7O2BPKI1mMlUSizqRFpooCWfjZjcw
// SIG // XWGQu6TZ9Xf+1DoLHrYbOPIjmpuTEyZtr8s94s/9eof6
// SIG // pDGCA6owggOmAgEBMIHJMIG0MQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsT
// SIG // FlZlcmlTaWduIFRydXN0IE5ldHdvcmsxOzA5BgNVBAsT
// SIG // MlRlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy52ZXJp
// SIG // c2lnbi5jb20vcnBhIChjKTA0MS4wLAYDVQQDEyVWZXJp
// SIG // U2lnbiBDbGFzcyAzIENvZGUgU2lnbmluZyAyMDA0IENB
// SIG // AhBK3o+durlKI29SNKQN+T5+MAkGBSsOAwIaBQCggbQw
// SIG // GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
// SIG // BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcN
// SIG // AQkEMRYEFOVsq2+jaDQ9BKoqXpUjEvOLeQDBMFQGCisG
// SIG // AQQBgjcCAQwxRjBEoCaAJABBAHUAdABvAGQAZQBzAGsA
// SIG // IABDAG8AbQBwAG8AbgBlAG4AdKEagBhodHRwOi8vd3d3
// SIG // LmF1dG9kZXNrLmNvbSAwDQYJKoZIhvcNAQEBBQAEgYCZ
// SIG // l/O7wdSJgFWpHs2tz73Fh88NCwmC/6PQ9xbUeJQQ2HoI
// SIG // tIW+rPw2WKo1JHdSp3TenAmaI2e/selt4ISWiG3XQQaw
// SIG // w4AhDlWGoKfvvLY1WeIz4bafhb/FAIm6OfAZnSyHi00G
// SIG // 6J7k4hWqE6RCi6alHI/8+tsedvTCuh/ZkfWEiaGCAX8w
// SIG // ggF7BgkqhkiG9w0BCQYxggFsMIIBaAIBATBnMFMxCzAJ
// SIG // BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5j
// SIG // LjErMCkGA1UEAxMiVmVyaVNpZ24gVGltZSBTdGFtcGlu
// SIG // ZyBTZXJ2aWNlcyBDQQIQOCXX+vhhr570kOcmtdZa1TAJ
// SIG // BgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3
// SIG // DQEHATAcBgkqhkiG9w0BCQUxDxcNMDkwMjAzMjMyODUw
// SIG // WjAjBgkqhkiG9w0BCQQxFgQU9XktJmogR9HmIApLM8e2
// SIG // 8LnsOnEwDQYJKoZIhvcNAQEBBQAEgYCJB8u023t4WgoC
// SIG // 8k7NYOfUpLSNjJP01QN3j9OjFMtsdmayUOZRnvXeUPte
// SIG // atDFHvkQiXSKu6SCvdvt+Rr92WYvg9rXO+Fl277/aUXE
// SIG // zVbW+yZjCyMhXcXrKxavCmipOy+/aTWvejCImRp4c4ts
// SIG // UhX/bYG960Dkyqny2amJrEoIZw==
// SIG // End signature block
